﻿/*	1.0
	
	WHAT: 
	This opens/closes a tree node and all of its parent nodes
*/

// This function does not use  "function funcName("  because "this" would be undefined if it did.
var openParentNodes_selfTree = this;
var openParentNodes = function( deepNode, newOpenState, self_tree ){
	// sanity checks
	if( !deepNode )		return;
	if( self_tree instanceof mx.controls.Tree === false )		self_tree = openParentNodes_selfTree;
	if( self_tree instanceof mx.controls.Tree === false )		self_tree = _this;
	if( self_tree instanceof mx.controls.Tree === false )		return;
	if( newOpenState === undefined )												newOpenState = true;
	var rootNode = self_tree.dataProvider;
	if( deepNode === rootNode )		return;
	// open self
	if( deepNode.childNodes.length > 0 )		self_tree.setIsOpen( deepNode, newOpenState, false, true );
	// recursively open all parent nodes
	if( deepNode.parentNode )			openParentNodes( deepNode.parentNode, newOpenState, self_tree );
}// openParentNodes()